﻿Public Class JotAppSettings
    Public Sub New()
        Me.PageNumber = 0
        Me.Foreground = CType(Application.Current.Resources("PhoneForegroundColor"), Color)
        Me.Background = CType(Application.Current.Resources("PhoneBackgroundColor"), Color)
        Me.StrokeWidth = 3
    End Sub


    ' Public properties -- the actual application settins
    Public Property StrokeCollections() As List(Of StrokeCollection)
    Public Property PageNumber() As Integer
    Public Property Foreground() As Color
    Public Property Background() As Color
    Public Property StrokeWidth() As Integer


    Public Shared Function Load() As JotAppSettings
        Dim settings As JotAppSettings
        Dim iso = IsolatedStorageFile.GetUserStoreForApplication()

        If iso.FileExists("settings.xml") Then
            Dim stream = iso.OpenFile("settings.xml", FileMode.Open)
            Dim reader As New StreamReader(stream)

            Dim ser As New XmlSerializer(GetType(JotAppSettings))
            settings = TryCast(ser.Deserialize(reader), JotAppSettings)

            reader.Close()
        Else
            ' Create and initialize new JotAppSettings object
            settings = New JotAppSettings()
            settings.StrokeCollections = New List(Of StrokeCollection)()
            settings.StrokeCollections.Add(New StrokeCollection())
        End If

        iso.Dispose()
        Return settings
    End Function


    Public Sub Save()
        Dim iso = IsolatedStorageFile.GetUserStoreForApplication()
        Dim stream = iso.CreateFile("settings.xml")
        Dim writer As New StreamWriter(stream)

        Dim ser As New XmlSerializer(GetType(JotAppSettings))
        ser.Serialize(writer, Me)

        writer.Close()
        iso.Dispose()
    End Sub
End Class
